package restcontroller.sysmanage.develop.listsortscheme;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DataPool;

import java.lang.reflect.Method;
import java.util.ArrayList;

import static common.api.YOSAPI.yosApiIDMap;

@API(title = "排序方案管理")
public class listsortscheme extends Controller {
    public listsortscheme(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "排序方案查询列表")
    @CACHEING
    public String queryschemeList() throws YosException {
        /*
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("methodpath like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(" or apiid like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "排序方案列表查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            String methodpath = row.getString("methodpath");
            String classname = methodpath.substring(0, methodpath.lastIndexOf("."));
            String methodname = methodpath.substring(methodpath.lastIndexOf(".") + 1);
            try {
                Class clz = Class.forName(classname);
                Method method = clz.getDeclaredMethod(methodname);
                if (method.isAnnotationPresent(API.class)) {
                    row.put("notes", method.getAnnotation(API.class).title());
                } else {
                    row.put("notes", "");
                }
            } catch (Exception e) {
                row.put("notes", "");
            }
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "排序方案新增修改")
    @CACHEING_CLEAN(cms = {@cm(clazz = listsortscheme.class, method = {"queryschemeList"})})
    public String insertormodifyscheme() throws YosException {
        long sys_listsortschemeid = content.getLongValue("sys_listsortschemeid");
        String methodpath = content.getString("methodpath");
        long apiid = 0;
        long apiversion = 1;
        try {
            String classname = methodpath.substring(0, methodpath.lastIndexOf("."));
            String methodname = methodpath.substring(methodpath.lastIndexOf(".") + 1);
            Class clz = Class.forName(classname);
            Method method = clz.getDeclaredMethod(methodname);
            if (!method.isAnnotationPresent(API.class)) {
                return getErrReturnObject().setErrMsg(methodname + "不是有效的接口方法").toString();
            }
            API api = method.getAnnotation(API.class);
            String apiversionclassname = api.apiversion().getName().toLowerCase();
            if (apiversionclassname.startsWith("restcontroller.r$id") && apiversionclassname.contains("$v")) {
                apiversion = Integer.parseInt(api.apiversion().getSimpleName().replace("v", ""));
                apiid = Long.parseLong(apiversionclassname.replace("restcontroller.r$id", "").replace("$v" + apiversion, ""));
            }
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg(methodpath + "找不到该接口方法").toString();
        }
        if (dbConnect.runSqlQuery("select sys_listsortschemeid from sys_listsortscheme where sys_listsortschemeid!=" + sys_listsortschemeid + " and methodpath='" + methodpath + "'").isNotEmpty()) {
            if (apiid > 0) {
                dbConnect.runSqlUpdate("update sys_listsortscheme set apiid='" + apiid + "', apiversion='" + apiversion + "' where methodpath='" + methodpath + "'");
                return getErrReturnObject().setErrMsg("该方法路径已存在！apiid:" + apiid + ";apiversion:" + apiversion).toString();
            }
            return getErrReturnObject().setErrMsg("该方法路径已存在！").toString();
        }
        SQLFactory sqlFactory = null;
        if (sys_listsortschemeid <= 0 || dbConnect.runSqlQuery("select sys_listsortschemeid from sys_listsortscheme where sys_listsortschemeid=" + sys_listsortschemeid).isEmpty()) {
            sys_listsortschemeid = createTableID("sys_listsortscheme");
            sqlFactory = new SQLFactory(this, "排序方案新增");
            sqlFactory.addParameter("sys_listsortschemeid", sys_listsortschemeid);
            sqlFactory.addParameter("methodpath", methodpath);
            if (apiid > 0) {
                sqlFactory.addParameter("apiid", apiid);
                sqlFactory.addParameter("apiversion", apiversion);
            } else {
                sqlFactory.addParameter("apiid", "");
                sqlFactory.addParameter("apiversion", "");
            }
        }
        dbConnect.runSqlUpdate(sqlFactory);
        return queryschemeList();
    }

    @API(title = "排序方案新增修改,id模式")
    @CACHEING_CLEAN(cms = {@cm(clazz = listsortscheme.class, method = {"queryschemeList"})})
    public String insertormodifyschemebyid() throws YosException {
        long sys_listsortschemeid = content.getLongValue("sys_listsortschemeid");
        long apiid = content.getLong("id");
        int version = content.getIntValue("version");
        version = (version == 0) ? 1 : version;

        if (!yosApiIDMap.containsKey(apiid)) {
            return getErrReturnObject().setErrMsg(apiid + "不是有效的接口id").toString();
        }
        if (!yosApiIDMap.get(apiid).containsKey(version)) {
            return getErrReturnObject().setErrMsg(apiid + "不是有效的接口version").toString();
        }
        YOSAPI yosapi = yosApiIDMap.get(apiid).get(version);
        Class clz = yosapi.getClazz();
        Method method = yosapi.getMethod();

        if (dbConnect.runSqlQuery("select sys_listsortschemeid from sys_listsortscheme where sys_listsortschemeid!=" + sys_listsortschemeid + " and methodpath='" + clz.getName() + "." + method.getName() + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("该方法路径已存在！").toString();
        }
        if (dbConnect.runSqlQuery("select sys_listsortschemeid from sys_listsortscheme where sys_listsortschemeid!=" + sys_listsortschemeid + " and apiid='" + apiid + "' and apiversion='" + version + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("该方法路径已存在！").toString();
        }
        SQLFactory sqlFactory = null;
        if (sys_listsortschemeid <= 0 || dbConnect.runSqlQuery("select sys_listsortschemeid from sys_listsortscheme where sys_listsortschemeid=" + sys_listsortschemeid).isEmpty()) {
            sys_listsortschemeid = createTableID("sys_listsortscheme");
            sqlFactory = new SQLFactory(this, "排序方案新增");
            sqlFactory.addParameter("sys_listsortschemeid", sys_listsortschemeid);
            sqlFactory.addParameter("methodpath", clz.getName() + "." + method.getName());
            sqlFactory.addParameter("apiid", apiid);
            sqlFactory.addParameter("apiversion", version);
        }
        dbConnect.runSqlUpdate(sqlFactory);
        return queryschemeList();
    }

    @API(title = "排序方案删除")
    @CACHEING_CLEAN(cms = {@cm(clazz = listsortscheme.class, method = {"queryschemeList"})})
    public String delete_scheme() throws YosException {
        long sys_listsortschemeid = content.getLong("sys_listsortschemeid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_listsortscheme where sys_listsortschemeid=" + sys_listsortschemeid);
        list.add("delete from sys_listsortschememx where sys_listsortschemeid=" + sys_listsortschemeid);
        dbConnect.runSqlUpdate(list);
        updateSortingPool(sys_listsortschemeid);
        return queryschemeList();
    }


    @API(title = "列表排序方案明细列表")
    @CACHEING
    public String queryschememxList() throws YosException {
        long sys_listsortschemeid = content.getLongValue("sys_listsortschemeid");
        SQLFactory sqlFactory = new SQLFactory(this, "排序方案明细列表查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("sys_listsortschemeid", sys_listsortschemeid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "排序方案明细新增修改")
    @CACHEING_CLEAN(cms = {@cm(clazz = listsortscheme.class, method = {"queryschememxList"})})
    public String insertormodifyschememx() throws YosException {
        long sortid = content.getLongValue("sortid");
        long sys_listsortschemeid = content.getLong("sys_listsortschemeid");
        String sortname = content.getString("sortname");
        String sortsql = content.getString("sortsql", true);
        boolean sorted = content.getBooleanValue("sorted");

        SQLFactory sqlFactory = null;
        if (sys_listsortschemeid <= 0 || dbConnect.runSqlQuery("select sortid from sys_listsortschememx where sys_listsortschemeid='" + sys_listsortschemeid + "' and sortid=" + sortid).isEmpty()) {
            sortid = createTableID("sys_listsortschememx");
            sqlFactory = new SQLFactory(this, "排序方案明细新增");
            sqlFactory.addParameter("sortid", sortid);
            sqlFactory.addParameter("sortname", sortname);
            sqlFactory.addParameter("sorted", sorted);
            sqlFactory.addParameter("sortsql", sortsql);
            sqlFactory.addParameter("sys_listsortschemeid", sys_listsortschemeid);
        } else {
            sqlFactory = new SQLFactory(this, "排序方案明细修改");
            sqlFactory.addParameter("sortid", sortid);
            sqlFactory.addParameter("sortname", sortname);
            sqlFactory.addParameter("sorted", sorted);
            sqlFactory.addParameter("sortsql", sortsql);
            sqlFactory.addParameter("sys_listsortschemeid", sys_listsortschemeid);
        }
        dbConnect.runSqlUpdate(sqlFactory);
        updateSortingPool(sys_listsortschemeid);
        return queryschememxList();
    }

    @API(title = "排序方案明细删除")
    @CACHEING_CLEAN(cms = {@cm(clazz = listsortscheme.class, method = {"queryschememxList"})})
    public String delete_schememx() throws YosException {
        long sys_listsortschemeid = content.getLong("sys_listsortschemeid");
        long sortid = content.getLong("sortid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_listsortschememx where sys_listsortschemeid=" + sys_listsortschemeid + " and sortid=" + sortid);
        dbConnect.runSqlUpdate(list);
        updateSortingPool(sys_listsortschemeid);
        return queryschememxList();
    }

    private void updateSortingPool(long sys_listsortschemeid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select methodpath from sys_listsortscheme where sys_listsortschemeid=" + sys_listsortschemeid);
        if (rows.isNotEmpty()) {
            String methodpath = rows.get(0).getString("methodpath");
//            Rows sortrows = dbConnect.runSqlQuery("select t2.sortid,t2.sortname,t2.sortsql,t2.sorted from sys_listsortscheme t1 " +
//                    "inner join sys_listsortschememx t2 on t1.sys_listsortschemeid=t2.sys_listsortschemeid " +
//                    "where t1.methodpath='" + methodpath + "'");
            DataPool.remove("sort:" + methodpath);
        }
    }
}
