package restcontroller.sysmanage.develop.datafunction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.SimpleInsert;
import common.data.SimpleUpdate;

import java.util.Iterator;

public class datafunction extends Controller {
    public datafunction(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统函数注册查询")
    public String queryFunctionList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select *from sys_datafunction order by createdate desc");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统函数注册")
    public String insertormodifyFunction() throws YosException {
        long sys_datafunctionid = content.getLong("sys_datafunctionid");
        String functionname = content.getString("functionname");
        String type = content.getString("type");
        boolean queryforpage = content.getBooleanValue("queryforpage");
        String sqlstr = content.getString("sqlstr", true);
        String remarks = content.getString("remarks");
        if (sys_datafunctionid <= 0 || dbConnect.runSqlQuery("select * from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid).isEmpty()) {
            SimpleInsert simpleInsert = SQLFactory.getSimpleInsert("sys_datafunction");
            simpleInsert.addValueField("sys_datafunctionid", createTableID("sys_datafunction"));
            simpleInsert.addValueField("functionname", functionname);
            simpleInsert.addValueField("type", type);
            simpleInsert.addValueField("queryforpage", queryforpage);
            simpleInsert.addValueField("sqlstr", sqlstr);
            simpleInsert.addValueField("remarks", remarks);
            simpleInsert.addDateField("createdate");
            simpleInsert.run(dbConnect);
        } else {
            SimpleUpdate simpleUpdate = SQLFactory.getSimpleUpdate("sys_datafunction");
            simpleUpdate.addValueField("sqlstr", sqlstr);
            simpleUpdate.addValueField("remarks", remarks);
            simpleUpdate.addValueField("queryforpage", queryforpage);
            simpleUpdate.addWhere("sys_datafunctionid", sys_datafunctionid);
            simpleUpdate.run(dbConnect);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "系统函数删除")
    public String deleteFunction() throws YosException {
        long sys_datafunctionid = content.getLong("sys_datafunctionid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("系统函数不存在").toString();
        } else if (rows.get(0).getBoolean("isused")) {
            return getErrReturnObject().setErrMsg("系统函数已被使用").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid);
        return getSucReturnObject().toString();
    }

    @API(title = "函数执行")
    public String execute() throws YosException {
        String functionname = content.getString("functionname");
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where functionname='" + functionname + "'");
        if (rows.isEmpty()) {
            JSONArray array = new JSONArray();
            array.add(new JSONObject());
            return getSucReturnObject().setData(array).toString();
        }
        if (!rows.get(0).getBoolean("isused")) {
            dbConnect.runSqlUpdate("update sys_datafunction set isused=1 where functionname='" + functionname + "'");
        }
        String type = rows.get(0).getString("type");
        String sql = rows.get(0).getString("sqlstr");

        if (content.containsKey("parameter")) {
            JSONObject parameterObject = content.getJSONObject("parameter");
            Iterator<String> it = parameterObject.keySet().iterator();
            while (it.hasNext()) {
                String parameter = it.next();
                String value = String.valueOf(parameterObject.get(parameter));
                String sqlkey = "$" + parameter + "$";
                if (value == null || "null".equalsIgnoreCase(value)) {
                    sql = sql.replace(sqlkey, "NULL");
                } else {
                    sql = sql.replace(sqlkey, "'" + value + "'");
                }
            }
        }
        sql = sql.replaceAll("(?i):sys_enterpriseid", "'" + sys_enterpriseid + "'");
        sql = sql.replaceAll("(?i):userid", "'" + userid + "'");
        sql = sql.replaceAll("(?i):hrid", "'" + hrid + "'");
        sql = sql.replaceAll("(?i):departmentid", "'" + departmentid + "'");
        sql = sql.replaceAll("(?i):siteid", "'" + siteid + "'");

        if (type.equals("query")) {
            Rows datarows;
            if (rows.get(0).getBoolean("queryforpage")) {
                SQLFactory sqlFactory = new SQLFactory("sql:" + sql, pageSize, pageNumber, "");
                datarows = dbConnect.runSqlQuery(sqlFactory.getSQL());
            } else {
                datarows = dbConnect.runSqlQuery(sql);
            }
            return getSucReturnObject().setData(datarows).toString();
        } else if (type.equals("update")) {
            int rowcount = dbConnect.runSqlUpdate(sql);
            return getSucReturnObject().setData(rowcount).toString();
        }
        return getErrReturnObject().setErrMsg("没有可执行的函数").toString();
    }
}
