package restcontroller.sysmanage.develop.attachment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

public class Attachment extends Controller {
    public Attachment(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据关联展示规则列表查询")
    public String querylinkdatashow() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "数据关联展示规则列表查询");
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            row.put("datafields", row.getJSONArray("datafields"));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "数据关联展示规则新增、修改")
    public String insertorupdatelinkdatashow() throws YosException {
        String ownertable = content.getString("ownertable");
        String appname = content.getString("appname");
        JSONArray datafields = content.getJSONArray("datafields");

        SQLFactory sqlFactory;
        if (dbConnect.runSqlQuery("select * from sys_attachment_linkdatashow where ownertable='" + ownertable + "'").isEmpty()) {
            sqlFactory = new SQLFactory(this, "数据关联展示规则新增");
            sqlFactory.addParameter("sys_attachment_linkdatashowid", createTableID("sys_attachment_linkdatashow"));
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("appname", appname);
            sqlFactory.addParameter("datafields", datafields.toJSONString());
        } else {
            sqlFactory = new SQLFactory(this, "数据关联展示规则修改");
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("appname", appname);
            sqlFactory.addParameter("datafields", datafields.toJSONString());
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    @API(title = "数据关联展示规则新增、修改")
    public String deletelinkdatashow() throws YosException {
        String ownertable = content.getString("ownertable");
        dbConnect.runSqlUpdate("delete from sys_attachment_linkdatashow where ownertable='" + ownertable + "'");
        return getSucReturnObject().toString();
    }

}
