package restcontroller.sysmanage.develop.api;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;

public class SqlModel extends Controller {
    public SqlModel(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "SQL模板库查询")
    public String querySqlModelList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("functionname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or functionpath like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or notes like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory("sql:select * from sys_function where $where$");
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "SQL模板参数查询")
    public String querySqlModelParmList() throws YosException {
        long sys_functionid = content.getLong("sys_functionid");
        SQLFactory sqlFactory = new SQLFactory("sql:select * from sys_function_parm where sys_functionid=" + sys_functionid + " order by sequence");
        RowsMap rowsmap = dbConnect.runSqlQuery(sqlFactory.getSQL()).toRowsMap("type");
        JSONObject object = new JSONObject();
        for (String type : rowsmap.keySet()) {
            object.put(type, rowsmap.get(type));
        }
        return getSucReturnObject().setData(object).toString();
    }

    @API(title = "SQL模板更新")
    public String insertOrModifySqlModel() throws YosException {
        long sys_functionid = content.getLongValue("sys_functionid");
        String functionname = content.getString("functionname");
        String notes = content.getString("notes");
        String functionpath = content.getString("functionpath");
        if (sys_functionid <= 0 || dbConnect.runSqlQuery("select * from sys_function where sys_functionid=" + sys_functionid).isEmpty()) {
            sys_functionid = createTableID("sys_function");
            SQLFactory sqlFactory = new SQLFactory(this, "SQL模板新增");
            sqlFactory.addParameter("sys_functionid", sys_functionid);
            sqlFactory.addParameter("functionname", functionname);
            sqlFactory.addParameter("notes", notes);
            sqlFactory.addParameter("functionpath", functionpath);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "SQL模板修改");
            sqlFactory.addParameter("sys_functionid", sys_functionid);
            sqlFactory.addParameter("functionname", functionname);
            sqlFactory.addParameter("notes", notes);
            sqlFactory.addParameter("functionpath", functionpath);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().toString();
    }

    @API(title = "SQL模板参数更新")
    public String insertOrModifySqlModelParm() throws YosException {
        long sys_function_parmid = content.getLongValue("sys_function_parmid");
        long sys_functionid = content.getLong("sys_functionid");
        int type = content.getIntValue("type");
        String parm = content.getString("parm");
        String datatype = content.getString("datatype");
        String notes = content.getString("notes");
        if (sys_function_parmid <= 0 || dbConnect.runSqlQuery("select * from sys_function_parm where sys_function_parmid=" + sys_function_parmid).isEmpty()) {
            sys_function_parmid = createTableID("sys_function_parm");
            SQLFactory sqlFactory = new SQLFactory(this, "SQL模板参数新增");
            sqlFactory.addParameter("sys_function_parmid", sys_function_parmid);
            sqlFactory.addParameter("sys_functionid", sys_functionid);
            sqlFactory.addParameter("type", type);
            sqlFactory.addParameter("parm", parm);
            sqlFactory.addParameter("datatype", datatype);
            sqlFactory.addParameter("notes", notes);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "SQL模板参数修改");
            sqlFactory.addParameter("sys_function_parmid", sys_function_parmid);
            sqlFactory.addParameter("parm", parm);
            sqlFactory.addParameter("datatype", datatype);
            sqlFactory.addParameter("notes", notes);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().toString();
    }
}
