package restcontroller.sysmanage.develop.api;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Api extends Controller {
    public Api(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "YOSapi接口查询")
    public String queryApiList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("apiid like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory("sql:select * from sys_api where $where$");
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "YOSapi接口详情查询")
    public String queryApiMain() throws YosException {
        long sys_apiid = content.getLongValue("sys_apiid");
        SQLFactory sqlFactory = new SQLFactory("sql:select * from sys_api where sys_apiid=" + sys_apiid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        if (rows.isNotEmpty()) {
            return getSucReturnObject().setData(rows.get(0)).toString();
        } else {
            return getErrReturnObject().setErrMsg("找不到接口信息").toString();
        }
    }

    @API(title = "YOSapi接口更新")
    public String insertOrModifyApi() throws YosException {
        long sys_apiid = content.getLongValue("sys_apiid");
        String title = content.getString("title");
        String notes = content.getString("notes");
        boolean accesstoken = content.getBooleanValue("accesstoken");
        long intervaltime = content.getLongValue("intervaltime");
        int version = content.getIntValue("version", 1);
        boolean cacheing = content.getBooleanValue("cacheing");

        if (sys_apiid <= 0 || dbConnect.runSqlQuery("select * from sys_api where sys_apiid=" + sys_apiid).isEmpty()) {
            sys_apiid = createTableID("sys_api");
            SQLFactory sqlFactory = new SQLFactory(this, "API新增");
            sqlFactory.addParameter("sys_apiid", sys_apiid);
            sqlFactory.addParameter("apiid", new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime()) + "00");
            sqlFactory.addParameter("title", title);
            sqlFactory.addParameter("notes", notes);
            sqlFactory.addParameter("accesstoken", accesstoken);
            sqlFactory.addParameter("intervaltime", intervaltime);
            sqlFactory.addParameter("version", version);
            sqlFactory.addParameter("cacheing", cacheing);
            sqlFactory.addParameter("createby", username);
            content.put("sys_apiid", sys_apiid);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "API修改");
            sqlFactory.addParameter("sys_apiid", sys_apiid);
            sqlFactory.addParameter("title", title);
            sqlFactory.addParameter("notes", notes);
            sqlFactory.addParameter("accesstoken", accesstoken);
            sqlFactory.addParameter("intervaltime", intervaltime);
            sqlFactory.addParameter("version", version);
            sqlFactory.addParameter("cacheing", cacheing);
            sqlFactory.addParameter("changeby", username);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return queryApiMain();
    }


}
