package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_userrequestlog implements YosObject {
    @Override
    public String table_comment() {
        return "用户接口请求日志记录表";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("userrequestlogid", "记录id");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new DateCol("date", "日期", "日期", true, false, "", 3));
        arrayList.add(new IntCol("requesttimes", "当日请求次数", "当日请求次数", true, false, false, 0, 4));
        arrayList.add(new VarcharCol("ip", "用户ip", "用户ip", 50, true, false, false, "", 6));
        arrayList.add(new VarcharCol("useragent", "请求来源", "请求来源", 5000, true, false, false, "", 7));
        arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, true, false, false, "", 7));
        arrayList.add(new BigIntCol("usersiteid", "用户站点id", "用户站点id", true, false, false, 0, 2));
        arrayList.add(new BigIntCol("userid", "用户id", "用户id", true, false, false, 0, 1));
        arrayList.add(new DateTimeCol("lastrequestdate", "当日最后一次执行时间", "当日最后一次执行时间", true, false, "", 5));
        return arrayList;
    }
}
