package objectregister.javapoet;

import com.squareup.javapoet.*;
import common.YosException;
import common.data.Row;
import common.data.RowsMap;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import javax.lang.model.element.Modifier;
import java.io.File;
import java.util.ArrayList;

public class ObjectRegister {

    public static String filepath = "./YOS_CORE/src/core";
    public static String packagename = "objectregister";

    public static void main(String[] args) throws YosException {
        new ObjectRegister(filepath, packagename, "sys_userrequestlog");
    }

    private TypeSpec.Builder builder;
    private DBConnect dbConnect = new DBConnect();
    private Row tableRow;
    private RowsMap columnRowsMap;

    public ObjectRegister(String filepath, String packagename, String table_name) throws YosException {
        tableRow = dbConnect.runSqlQuery(0, "select table_comment,uniquecolumnname from sys_object where table_name='" + table_name + "'");
        columnRowsMap = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "'").toRowsMap("column_name");

        builder = TypeSpec.classBuilder(table_name);
        builder.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        builder.addSuperinterface(YosObject.class);

        builder.addMethod(addTable_comment());
        builder.addMethod(addUniquecolumn());
        builder.addMethod(addTable_cols());
        try {
            TypeSpec testCode = builder.build();
            // 定义一个java文件，指定package和类定义
            JavaFile javaFile = JavaFile.builder(packagename, testCode).build();
            // 将java文件内容写入文件中
            File file = new File(filepath);
            javaFile.writeTo(file);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private MethodSpec addTable_comment() {
        MethodSpec methodSpec = MethodSpec.methodBuilder("table_comment").addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .returns(String.class)
                .addCode("return \"" + tableRow.getString("table_comment") + "\";")
                .build();
        return methodSpec;
    }


    private MethodSpec addUniquecolumn() throws YosException {
        String uniquecolumnname = tableRow.getString("uniquecolumnname");
        String column_title = columnRowsMap.get(uniquecolumnname).get(0).getString("column_title");

        MethodSpec methodSpec = MethodSpec.methodBuilder("uniquecolumn").addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .returns(YosObject.UniqueCol.class)
                .addCode("return new UniqueCol(\"" + uniquecolumnname + "\", \"" + column_title + "\");")
                .build();
        return methodSpec;
    }

    private MethodSpec addTable_cols() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("table_cols").addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .returns(ParameterizedTypeName.get(ClassName.get(ArrayList.class), ClassName.get(YosObjectCol.class)));

        columnRowsMap.remove(tableRow.getString("uniquecolumnname"));
        builder.addCode("ArrayList<YosObjectCol> arrayList = new ArrayList<>();\n");
        for (String column_name : columnRowsMap.keySet()) {
            Row columnRow = columnRowsMap.get(column_name).getRow(0);
            String column_title = columnRow.getString("column_title");
            String column_comment = columnRow.getString("column_comment");
            int numeric_precision = columnRow.getInteger("numeric_precision");
            int numeric_scale = columnRow.getInteger("numeric_scale");
            boolean is_nullable = columnRow.getBoolean("is_nullable");
            boolean uniqued = columnRow.getBoolean("uniqued");
            boolean savedatalog = columnRow.getBoolean("savedatalog");
            String column_default = columnRow.getString("column_default");
            int sequence = columnRow.getInteger("sequence");

            switch (columnRow.getString("column_type")) {
                case "varchar": {
                    builder.addCode("arrayList.add(new VarcharCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + numeric_precision + ", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n");
                    break;
                }
                case "text": {
                    builder.addCode("arrayList.add(new TextCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n");
                    break;
                }
                case "longtext": {
                    builder.addCode("arrayList.add(new LongTextCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n");
                    break;
                }
                case "json": {
                    builder.addCode("arrayList.add(new LongTextCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", " + sequence + "));\n");
                    break;
                }
                case "date": {
                    builder.addCode("arrayList.add(new DateCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n");
                    break;
                }
                case "datetime": {
                    builder.addCode("arrayList.add(new DateTimeCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n");
                    break;
                }
                case "int": {
                    builder.addCode("arrayList.add(new IntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + (column_default.equals("") ? 0 : column_default) + ", " + sequence + "));\n");
                    break;
                }
                case "bigint": {
                    builder.addCode("arrayList.add(new BigIntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + (column_default.equals("") ? 0 : column_default) + ", " + sequence + "));\n");
                    break;
                }
                case "smallint": {
                    builder.addCode("arrayList.add(new SmallIntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + (column_default.equals("") ? 0 : column_default) + ", " + sequence + "));\n");
                    break;
                }
                case "decimal": {
                    builder.addCode("arrayList.add(new DecimalCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + numeric_precision + ", " + numeric_scale + ", " + ", " + is_nullable + ", " + savedatalog + ", " + (column_default.equals("") ? 0 : column_default) + ", " + sequence + "));\n");
                    break;
                }
            }
        }
        builder.addCode("return arrayList;");
        return builder.build();
    }
}
