package common;

import common.data.Rows;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;

/**
 * 定时任务类父类，所有定时任务类都必须继承该类
 */
public abstract class ServiceController extends BaseClass implements Runnable {

    @Override
    public void run() {
        try {
            String classname = getClass().getSimpleName();
            if (checkServicesUsed(classname)) {
                System.out.println("自动任务执行：" + classname);
                dbConnect.runSqlUpdate("update sys_services set lastruntime=now() where classname='" + classname + "'");
                int successed = 1;
                long starttime = Calendar.getInstance().getTimeInMillis();
                try {
                    serviceRun();
                } catch (Exception e) {
                    e.printStackTrace();
                    successed = 0;
                } finally {
                    try {
                        long timelong = Calendar.getInstance().getTimeInMillis() - starttime;
                        dbConnect.runSqlUpdate("update sys_services set successed=" + successed + ",timelong=" + timelong + " where classname='" + classname + "'");
                    } catch (YosException e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (YosException e) {
            e.printStackTrace();
        }
    }

    public abstract void serviceRun() throws YosException;

    private boolean checkServicesUsed(String classname) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select isused from sys_services where classname='" + classname + "' and isused=1 ");
        return !rows.isEmpty();
    }
}
