package beans.socket;

import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import common.parameter.parameter;
import common.websocket.WebSocket;

import java.util.ArrayList;

public class Socket {
    /**
     * 向指定的账号发送信息，该账号各个登陆站点都会收到该信息
     *
     * @param userid
     * @param type
     * @param data
     * @throws YosException
     */
    public static void sendData(Long userid, String type, Object data) throws YosException {
        sendData(null, userid, type, data);
    }

    /**
     * 向指定的账号发送信息，该账号指定站点都会收到该信息
     *
     * @param siteid
     * @param userid
     * @param type
     * @param data
     * @throws YosException
     */
    public static void sendData(String siteid, Long userid, String type, Object data) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows;
        if (siteid == null) {
            rows = dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid='" + userid + "'");
        } else {
            rows = dbConnect.runSqlQuery("select usersiteid from sys_usersite where siteid='" + siteid + "' and userid='" + userid + "'");
        }
        for (long usersiteid : rows.toArrayList("usersiteid", new ArrayList<Long>())) {
            if (parameter.websocketClients.containsKey(usersiteid)) {
                JSONObject methodobject = new JSONObject();
                methodobject.put("class", "data");//数据
                methodobject.put("type", type);//数据分类
                methodobject.put("data", data);//数据实体
                for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                    webClientSocket.sendSystemMessage(methodobject);
                }
            }
        }
    }

    /**
     * 向系统管理员账号发送信息
     *
     * @param type
     * @param data
     * @throws YosException
     */
    public static void sendData(String type, Object data) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select userid from sys_users where sysadministrator=1");
        for (Long userid : rows.toArrayList("userid", new ArrayList<Long>())) {
            Rows usersiteRows = dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid='" + userid + "'");
            for (long usersiteid : usersiteRows.toArrayList("usersiteid", new ArrayList<Long>())) {
                if (parameter.websocketClients.containsKey(usersiteid)) {
                    JSONObject methodobject = new JSONObject();
                    methodobject.put("class", "data");//数据
                    methodobject.put("type", type);//数据分类
                    methodobject.put("data", data);//数据实体
                    for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                        if (webClientSocket.getSystemclient().equalsIgnoreCase("sysmanage")) {
                            webClientSocket.sendSystemMessage(methodobject);
                        }
                    }
                }
            }
        }
    }
}
