package utility.huawei.obs;

import beans.parameter.Parameter;
import com.huaweicloud.sdk.ces.v1.CesClient;
import com.huaweicloud.sdk.ces.v1.model.Datapoint;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataRequest;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataResponse;
import com.huaweicloud.sdk.ces.v1.region.CesRegion;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BucketCESManage extends BaseClass {
    protected String bucketname;
    protected CesClient cesClient;
    protected ArrayList<String> sqllist1;
    protected ArrayList<String> sqllist2;
    protected long fromtime;
    protected long totime;
    protected String yeaterday;

    private String getBucketname(String siteid) {
        try {
            Rows rows = dbConnect.runSqlQuery("select bucketname from sys_site where siteid='" + siteid + "'");
            if (rows.isNotEmpty()) {
                this.bucketname = rows.get(0).getString("bucketname").toLowerCase();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this.bucketname;
    }

    public BucketCESManage(String siteid) throws YosException {
        this.bucketname = getBucketname(siteid);
        ICredential auth = new BasicCredentials().withAk(Parameter.get("attachment_huawei_obs_ak")).withSk(Parameter.get("attachment_huawei_obs_sk"));
        cesClient = CesClient.newBuilder().withCredential(auth).withRegion(CesRegion.valueOf(Parameter.get("attachment_huawei_obs_location"))).build();
        sqllist1 = new ArrayList<>();
        sqllist2 = new ArrayList<>();
    }

    public void getData() throws YosException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        yeaterday = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select * from sys_obsdatalog where siteid='" + bucketname + "' and createdate='" + yeaterday + "'");

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        fromtime = calendar.getTimeInMillis();
        calendar.add(Calendar.DATE, 1);
        totime = calendar.getTimeInMillis();
        if (rows.size() < 6) {
            getDownload_traffic();
            if (!sqllist1.isEmpty()) {
                dbConnect.runSqlUpdate(sqllist1);
            }
            getUpload_traffic();
            if (!sqllist2.isEmpty()) {
                dbConnect.runSqlUpdate(sqllist2);
            }
        }
    }

    /**
     * 总下载流量
     */
    private void getDownload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("download_traffic");
        request.withDim0("bucket_name," + bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue("sum"));
        request.withPeriod(14400);
        request.withFrom(fromtime);
        request.withTo(totime);
        try {
            ShowMetricDataResponse response = cesClient.showMetricData(request);
            List<Datapoint> list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double downloadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();

                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);
                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());

                    SQLFactory factory1 = new SQLFactory(this, "数据流出量日志更新1");
                    factory1.addParameter("siteid", bucketname.toUpperCase());
                    factory1.addParameter("sys_obsdatalogid", createTableID("sys_obsdatalog"));
                    factory1.addParameter("timestamp", time);
                    factory1.addParameter("createdate", createdate);
                    factory1.addParameter("createtime", createtime);

                    SQLFactory factory2 = new SQLFactory(this, "数据流出量日志更新2");
                    factory2.addParameter("downloadbytes", downloadbytes);
                    factory2.addParameter("siteid", bucketname.toUpperCase());
                    factory2.addParameter("timestamp", time);

                    sqllist1.add(factory1.getSQL());
                    sqllist1.add(factory2.getSQL());
                }
            }
        } catch (ConnectionException e) {
            e.printStackTrace();
        } catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }

    public static void main(String[] args) throws YosException {
        BucketCESManage bucketCESManage = new BucketCESManage("DSB01");
        bucketCESManage.getDownload_traffic();
    }

    /**
     * 总上传流量
     */
    private void getUpload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("upload_traffic");
        request.withDim0("bucket_name," + bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue("sum"));
        request.withPeriod(14400);
        request.withFrom(fromtime);
        request.withTo(totime);
        try {
            ShowMetricDataResponse response = cesClient.showMetricData(request);
            List<Datapoint> list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double uploadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();

                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);

                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());

                    SQLFactory factory1 = new SQLFactory(this, "数据上传量日志更新1");
                    factory1.addParameter("sys_obsdatalogid", createTableID("sys_obsdatalog"));
                    factory1.addParameter("siteid", bucketname.toUpperCase());
                    factory1.addParameter("timestamp", time);
                    factory1.addParameter("createdate", createdate);
                    factory1.addParameter("createtime", createtime);


                    SQLFactory factory2 = new SQLFactory(this, "数据上传量日志更新2");
                    factory2.addParameter("uploadbytes", uploadbytes);
                    factory2.addParameter("siteid", bucketname.toUpperCase());
                    factory2.addParameter("timestamp", time);
                    sqllist2.add(factory1.getSQL());
                    sqllist2.add(factory2.getSQL());
                }
            }
        } catch (ConnectionException e) {
            e.printStackTrace();
        } catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }
}
