package utility.bankdocking.ccb;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import common.BaseClass;
import common.YosException;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * 中国建设银行对接
 */
public class BBC extends BaseClass {

    public JSONArray query(String siteid, int startdate, int enddate) throws YosException {
        String bank_bbc_used = Parameter.get(siteid, "bank_bbc_used");
        if (!bank_bbc_used.equals("1")) {
            return new JSONArray();
        }
        BBC BBC = new BBC();
        ArrayList<HashMap<String, String>> list = new ArrayList<>();
        try {
            XmlFactory factory = new XmlFactory();
            for (int i = 1; i < 9999; i++) {
                String xml = factory.createGetBankDataXml(siteid, startdate, enddate, i);
                String result = BBC.SockerServer(siteid, xml);
                if (factory.getReturnCode(result).equals("000000")) {
                    boolean hasdata = factory.getListByXml(list, result);
                    if (!hasdata) {
                        break;
                    }
                } else {
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return (JSONArray) JSON.toJSON(list);
    }

    private String SockerServer(String siteid, String requestXml) throws Exception {
        // 为了简单起见，所有的异常都直接往外抛
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(Parameter.get(siteid, "bank_ccb_host"), Integer.parseInt(Parameter.get(siteid, "bank_ccb_port"))), 10000);
        socket.setSoTimeout(10000);
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());

        byte[] chrCharArray; // 创建一个字符数组chrCharArray
        chrCharArray = requestXml.getBytes(); // 将字符串变量转换为字符数组
        out.write(chrCharArray);// 把报文结构发送到服务器端
        InputStream in1 = socket.getInputStream();
        Charset cs = Charset.forName("gbk");
        InputStreamReader isr = new InputStreamReader(in1, cs);
        // 获取文件名
        String[] str = new String[128];
        StringBuffer sb = new StringBuffer();
        try {
            int tempchar;
            int i = 0;
            int flag = 0;
            while ((tempchar = isr.read()) != -1) {
                // 对于windows下，\r\n这两个字符在一起时，表示一个换行。
                // 但如果这两个字符分开显示时，会换两次行。
                // 因此，屏蔽掉\r，或者屏蔽\n。否则，将会多出很多空行。
                if (((char) tempchar) != '\r' && ((char) tempchar) != '\n') {
                    if ((char) tempchar == '|') {
                        flag++;
                        if (flag == 33) {
                            flag = 0;
                            str[i] = sb.toString();
                            sb = new StringBuffer();
                            i++;
                        } else {
                            sb.append((char) tempchar);
                        }
                    } else {
                        sb.append((char) tempchar);
                    }
                }
            }
            isr.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        socket.close();
        return sb.toString();
    }

}
