package restcontroller.sysmanage.develop.wechatapp;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

import common.YosException;

@API(title = "微信操作端注，用于维护微信应用的相关参数")
public class wechatapp extends Controller {
    public wechatapp(JSONObject content) throws YosException {
        super(content);
    }


    @API(title = "微信操作端列表查询")
    @CACHEING
    public String query_wechatappList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_wechatapp");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "微信操作端新增，修改")
    @CACHEING_CLEAN(cms = {@cm(clazz = wechatapp.class, method = {"query_wechatappList"})})
    public String insertormodify_wechatapp() throws YosException {
        long wechatappid = content.getLong("wechatappid");
        String systemclient = content.getString("systemclient");
        String appid = content.getString("appid");
        String secret = content.getString("secret");
        String remarks = content.getString("remarks");
        String mch_id = content.getStringValue("mch_id");
        String mch_key = content.getStringValue("mch_key");

        SQLFactory sqlFactory = null;
        if (wechatappid <= 0 || dbConnect.runSqlQuery("select wechatappid from sys_wechatapp where wechatappid=" + wechatappid).isEmpty()) {
            if (!dbConnect.runSqlQuery("select wechatappid from sys_wechatapp where systemclient='" + systemclient + "'").isEmpty()) {
                return getErrReturnObject().setErrMsg("该操作端已注册，不可重复注册！").toString();
            }
            wechatappid = createTableID("sys_wechatapp");
            sqlFactory = new SQLFactory(this, "微信应用新增");
        } else {
            sqlFactory = new SQLFactory(this, "微信应用修改");
        }
        sqlFactory.addParameter("wechatappid", wechatappid);
        sqlFactory.addParameter("systemclient", systemclient);
        sqlFactory.addParameter("appid", appid);
        sqlFactory.addParameter("secret", secret);
        sqlFactory.addParameter("remarks", remarks);
        sqlFactory.addParameter("mch_id", mch_id);
        sqlFactory.addParameter("mch_key", mch_key);

        dbConnect.runSqlUpdate(sqlFactory);
        return query_wechatappList();
    }

    @API(title = "微信操作端删除")
    @CACHEING_CLEAN(cms = {@cm(clazz = wechatapp.class, method = {"query_wechatappList"})})
    public String delete_wechatapp() throws YosException {
        long wechatappid = content.getLong("wechatappid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_wechatapp where wechatappid=" + wechatappid);
        dbConnect.runSqlUpdate(list);
        return query_wechatappList();
    }
}
