package restcontroller.sysmanage.develop.userauthforweb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.parameter.parameter;
import utility.zentao.zentao;

import java.util.ArrayList;
import java.util.HashMap;

@API(title = "管理端-开发-权限管理-权限查询")
public class userauth extends Controller {
    public userauth(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "web端获取当前登陆角色授权信息")
    @CACHEING
    public String query_userauth() throws YosException {
        HashMap<Long, ArrayList<zentao.Task>> systemmoduleidTaskMap = new HashMap<>();
        HashMap<Long, ArrayList<zentao.Task>> systemappidTaskMap = new HashMap<>();
        HashMap<Long, ArrayList<zentao.Bug>> systemmoduleidBugMap = new HashMap<>();
        HashMap<Long, ArrayList<zentao.Bug>> systemappidBugMap = new HashMap<>();

//        if (properties.isdebug()) {
//            ArrayList<String> sqllist = new ArrayList<>();
//
//            zentao zentao = new zentao();
//
//            {//遍历任务及bug，如果已经解决，则将testpass改为1
//                //获取应用任务及bug信息
//                Rows zentaoTaskRows = dbConnect.runSqlQuery("select zentao.zentaoid,sys_systemapp.systemmoduleid,zentao.systemappid,zentao.type,zentao.id from zentao  inner join sys_systemapp on zentao.systemappid=sys_systemapp.systemappid where zentao.testpass=0 and zentao.type='task'");
//                HashMap<Long, zentao.Task> taskmap = zentao.getTask(zentaoTaskRows.toArrayList("id", new ArrayList<>()));
//                for (Row row : zentaoTaskRows) {
//                    if (taskmap.containsKey(row.getLong("id"))) {
//                        utility.zentao.zentao.Task task = taskmap.get(row.getLong("id"));
//                        if (task.getStatus().equalsIgnoreCase("done")) {
//                            sqllist.add("update zentao set testpass=1 where systemappid=" + row.getLong("systemappid") + "and type='task' and id=" + row.getLong("id"));
//                        } else {
//                            {
//                                ArrayList<zentao.Task> tasklist;
//                                if (systemmoduleidTaskMap.containsKey(row.getLong("systemmoduleid"))) {
//                                    tasklist = systemmoduleidTaskMap.get(row.getLong("systemmoduleid"));
//                                } else {
//                                    tasklist = new ArrayList<>();
//                                }
//                                tasklist.add(task);
//                                systemmoduleidTaskMap.put(row.getLong("systemmoduleid"), tasklist);
//                            }
//                            {
//                                ArrayList<zentao.Task> tasklist;
//                                if (systemappidTaskMap.containsKey(row.getLong("systemappid"))) {
//                                    tasklist = systemappidTaskMap.get(row.getLong("systemappid"));
//                                } else {
//                                    tasklist = new ArrayList<>();
//                                }
//                                tasklist.add(task);
//                                systemappidTaskMap.put(row.getLong("systemappid"), tasklist);
//                            }
//                        }
//                    } else {
//                        sqllist.add("update zentao set testpass=1 where systemappid=" + row.getLong("systemappid") + "and type='task' and id=" + row.getLong("id"));
//                    }
//                }
//            }
//
//            {//遍历任务及bug，如果已经解决，则将testpass改为1
//                Rows zentaoBugRows = dbConnect.runSqlQuery("select zentao.zentaoid,sys_systemapp.systemmoduleid,zentao.systemappid,zentao.type,zentao.id from zentao  inner join sys_systemapp on zentao.systemappid=sys_systemapp.systemappid where zentao.testpass=0 and zentao.type='bug'");
//                HashMap<Long, zentao.Bug> bugmap = zentao.getBug(zentaoBugRows.toArrayList("id", new ArrayList<>()));
//                for (Row row : zentaoBugRows) {
//                    if (bugmap.containsKey(row.getLong("id"))) {
//                        zentao.Bug bug = bugmap.get(row.getLong("id"));
//                        if (bug.getStatus().equalsIgnoreCase("done")) {
//                            sqllist.add("update zentao set testpass=1 where systemappid=" + row.getLong("systemappid") + "and type='bug' and id=" + row.getLong("id"));
//                        } else {
//                            {
//                                ArrayList<zentao.Bug> buglist;
//                                if (systemmoduleidBugMap.containsKey(row.getLong("systemmoduleid"))) {
//                                    buglist = systemmoduleidBugMap.get(row.getLong("systemmoduleid"));
//                                } else {
//                                    buglist = new ArrayList<>();
//                                }
//                                buglist.add(bug);
//                                systemmoduleidBugMap.put(row.getLong("systemmoduleid"), buglist);
//                            }
//                            {
//                                ArrayList<zentao.Bug> buglist;
//                                if (systemappidBugMap.containsKey(row.getLong("systemappid"))) {
//                                    buglist = systemappidBugMap.get(row.getLong("systemappid"));
//                                } else {
//                                    buglist = new ArrayList<>();
//                                }
//                                buglist.add(bug);
//                                systemappidBugMap.put(row.getLong("systemappid"), buglist);
//                            }
//                        }
//                    } else {
//                        sqllist.add("update zentao set testpass=1 where systemappid=" + row.getLong("systemappid") + "and type='bug' and id=" + row.getLong("id"));
//                    }
//                }
//            }
//            dbConnect.runSqlUpdate(sqllist);
//        }

        String showplace = "1";
        if (content.containsKey("place")) {
            showplace = content.getString("place");//1:工作台；2：快捷区；3：设置区
        }
        if (dbConnect.runSqlQuery("select * from sys_users where sysadministrator=1 and userid=" + userid).isEmpty()) {
            /**
             * 获取角色系统授权
             */
            SQLFactory systemsql = new SQLFactory(this, "获取角色系统授权");
            systemsql.addParameter("userid", userid);
            systemsql.addParameter("siteid", siteid);
            systemsql.addParameter("systemclient", systemclient);
            systemsql.addParameter("showplace", showplace);
            Rows systemRows = dbConnect.runSqlQuery(systemsql);
            /**
             * 获取角色模块授权
             */
            SQLFactory modulesql = new SQLFactory(this, "获取角色模块授权");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            modulesql.addParameter("showplace", showplace);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));

                if (systemappidTaskMap.containsKey(row.getLong("systemmoduleid"))) {
                    row.put("task", systemappidTaskMap.get(row.getLong("systemmoduleid")));
                } else {
                    row.put("task", new JSONArray());
                }
                if (systemappidBugMap.containsKey(row.getLong("systemmoduleid"))) {
                    row.put("bug", systemappidBugMap.get(row.getLong("systemmoduleid")));
                } else {
                    row.put("bug", new JSONArray());
                }
            }
            RowsMap moduleRowsMap = moduleRows.toRowsMap("systemid");

            /**
             * 获取角色应用授权
             */
            SQLFactory appsql = new SQLFactory(this, "获取角色应用授权");
            appsql.addParameter("userid", userid);
            appsql.addParameter("siteid", siteid);
            appsql.addParameter("systemclient", systemclient);
            appsql.addParameter("showplace", showplace);
            Rows appRows = dbConnect.runSqlQuery(appsql);
            for (Row appRow : appRows) {
                if (systemappidTaskMap.containsKey(appRow.getLong("systemappid"))) {
                    appRow.put("task", systemappidTaskMap.get(appRow.getLong("systemappid")));
                } else {
                    appRow.put("task", new JSONArray());
                }
                if (systemappidBugMap.containsKey(appRow.getLong("systemappid"))) {
                    appRow.put("bug", systemappidBugMap.get(appRow.getLong("systemappid")));
                } else {
                    appRow.put("bug", new JSONArray());
                }
            }
            RowsMap appRowsMap = appRows.toRowsMap("systemmoduleid");

            /**
             * 获取角色功能授权
             */
            SQLFactory optionsql = new SQLFactory(this, "获取角色功能授权");
            optionsql.addParameter("userid", userid);
            optionsql.addParameter("siteid", siteid);
            Rows OptionRows = dbConnect.runSqlQuery(optionsql);
            RowsMap optionRowsMap = OptionRows.toRowsMap("systemappid");
            /**
             * 获取角色限制栏位
             */
            SQLFactory hiddenfieldsql = new SQLFactory(this, "获取角色限制栏位");
            hiddenfieldsql.addParameter("userid", userid);
            hiddenfieldsql.addParameter("siteid", siteid);
            RowsMap hiddenfieldRowsMap = dbConnect.runSqlQuery(hiddenfieldsql).toRowsMap("systemappid");


            /**
             * 获取应用网格配置
             */
            SQLFactory gridsql = new SQLFactory(this, "获取角色应用网格配置");
            gridsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows gridrows = dbConnect.runSqlQuery(gridsql);
            RowsMap gridRowsMap = gridrows.toRowsMap("systemappid");

            /**
             * 获取应用表格配置
             */
            SQLFactory tablesql = new SQLFactory(this, "获取角色应用表格配置");
            tablesql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows tablerows = dbConnect.runSqlQuery(tablesql);
            RowsMap tableRowsMap = tablerows.toRowsMap("systemappid");

            SQLFactory tablecolsql = new SQLFactory(this, "获取角色应用表格栏位配置");
            tablecolsql.addParameter_in("tableid", tablerows.toArrayList("tableid"));
            Rows alltablecolRows = dbConnect.runSqlQuery(tablecolsql);
            RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select tablecolid,title,width,hidden from sys_systemapp_tablecols_site where siteid='" + siteid + "'").toRowsMap("tablecolid");
            ArrayList<Row> hiddenRow = new ArrayList<>();
            for (Row tablecolRow : alltablecolRows) {
                if (sitetablecolRowsMap.containsKey(tablecolRow.getString("tablecolid"))) {
                    Rows sitecolsRows = sitetablecolRowsMap.get(tablecolRow.getString("tablecolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        tablecolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("width") > 0) {
                        tablecolRow.put("width", sitecolsRows.get(0).getInteger("width"));
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        tablecolRow.put("hidden", 1);
                    }
                }
                if (tablecolRow.getBoolean("hidden")) {
                    hiddenRow.add(tablecolRow);
                }
            }
            for (Row row : hiddenRow) {
                alltablecolRows.remove(row);
            }
            RowsMap tablecolRowsMap = alltablecolRows.toRowsMap("tableid");

            /**
             * 获取应用小组件配置
             */
            SQLFactory wedgitsql = new SQLFactory(this, "获取角色应用小组件配置");
            wedgitsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            RowsMap wedgitRowsMap = dbConnect.runSqlQuery(wedgitsql).toRowsMap("systemappid");


            for (Row systemRow : systemRows) {
                Rows modulerows = moduleRowsMap.get(systemRow.getString("systemid"));
                for (Row moduleRow : modulerows) {
                    Rows approws = appRowsMap.get(moduleRow.getString("systemmoduleid"));
                    for (Row appRow : approws) {
                        String systemappid = appRow.getString("systemappid");

                        Rows optionRows = optionRowsMap.get(systemappid);
                        optionRows.removeColumn(new String[]{"systemappid"});

                        Rows hiddenfieldRows = hiddenfieldRowsMap.get(systemappid);
                        hiddenfieldRows.removeColumn(new String[]{"systemappid"});

                        Rows wedgitsRows = wedgitRowsMap.get(systemappid);
                        wedgitsRows.removeColumn(new String[]{"systemappid"});

                        JSONObject gridObject = new JSONObject();
                        Rows gridRows = gridRowsMap.get(systemappid);
                        for (Row gridRow : gridRows) {
                            gridObject.put(gridRow.getString("grid"), gridRow);
                        }
                        gridRows.removeColumn(new String[]{"systemappid", "grid", "gridid"});

                        JSONObject tableObject = new JSONObject();
                        Rows tableRows = tableRowsMap.get(systemappid);
                        for (Row tableRow : tableRows) {
                            Rows tablecolRows = tablecolRowsMap.get(tableRow.getString("tableid"));
                            tablecolRows.removeColumn(new String[]{"tablecolid"});
                            tableRow.put("tablecols", tablecolRows);
                            tableObject.put(tableRow.getString("table"), tableRow);
                        }
                        tableRows.removeColumn(new String[]{"systemappid", "table"});

                        JSONObject metaObject = new JSONObject();
                        metaObject.put("title", appRow.getString("systemappname"));
                        metaObject.put("auth", optionRows);
                        metaObject.put("hiddenfields", hiddenfieldRows);
                        metaObject.put("wedgits", wedgitsRows);
                        metaObject.put("grids", gridObject);
                        metaObject.put("tables", tableObject);

                        appRow.put("path", appRow.getString("apppath"));
                        appRow.put("name", appRow.getString("systemapp"));
                        appRow.put("meta", metaObject);
                        appRow.put("component", "");
                    }
                    moduleRow.put("apps", approws);
                }
                systemRow.put("modules", modulerows);
            }
            appRows.removeColumn(new String[]{"systemappname", "systemapp", "apppath"});
            parameter.userauth_systemids.put(userid, systemRows);
            parameter.userauth_systemmoduleids.put(userid, moduleRows);
            parameter.userauth_systemappids.put(userid, appRows);
            parameter.userauth_optionids.put(userid, OptionRows);
            return getSucReturnObject().setData(systemRows).toString();
        } else {
            /*
            系统管理员权限获取，无需授权，返回所有功能权限
             */
            /**
             * 获取角色系统授权
             */
            SQLFactory systemsql = new SQLFactory(this, "获取系统管理员角色系统授权");
            systemsql.addParameter("systemclient", systemclient);
            systemsql.addParameter("showplace", showplace);
            Rows systemRows = dbConnect.runSqlQuery(systemsql);
            /**
             * 获取角色模块授权
             */
            SQLFactory modulesql = new SQLFactory(this, "获取系统管理员角色模块授权");
            modulesql.addParameter("systemclient", systemclient);
            modulesql.addParameter("showplace", showplace);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
                if (systemappidTaskMap.containsKey(row.getLong("systemmoduleid"))) {
                    row.put("task", systemappidTaskMap.get(row.getLong("systemmoduleid")));
                } else {
                    row.put("task", new JSONArray());
                }
                if (systemappidBugMap.containsKey(row.getLong("systemmoduleid"))) {
                    row.put("bug", systemappidBugMap.get(row.getLong("systemmoduleid")));
                } else {
                    row.put("bug", new JSONArray());
                }
            }
            RowsMap moduleRowsMap = moduleRows.toRowsMap("systemid");
            /**
             * 获取角色应用授权
             */
            SQLFactory appsql = new SQLFactory(this, "获取系统管理员角色应用授权");
            appsql.addParameter("systemclient", systemclient);
            appsql.addParameter("showplace", showplace);
            Rows appRows = dbConnect.runSqlQuery(appsql);
            for (Row appRow : appRows) {
                if (systemappidTaskMap.containsKey(appRow.getLong("systemappid"))) {
                    appRow.put("task", systemappidTaskMap.get(appRow.getLong("systemappid")));
                } else {
                    appRow.put("task", new JSONArray());
                }
                if (systemappidBugMap.containsKey(appRow.getLong("systemappid"))) {
                    appRow.put("bug", systemappidBugMap.get(appRow.getLong("systemappid")));
                } else {
                    appRow.put("bug", new JSONArray());
                }
            }
            RowsMap appRowsMap = appRows.toRowsMap("systemmoduleid");

            /**
             * 获取角色功能授权
             */
            SQLFactory optionsql = new SQLFactory(this, "获取系统管理员角色功能授权");
            optionsql.addParameter("siteid", siteid);
            Rows OptionRows = dbConnect.runSqlQuery(optionsql);
            RowsMap optionRowsMap = OptionRows.toRowsMap("systemappid");

            /**
             * 获取应用网格配置
             */
            SQLFactory gridsql = new SQLFactory(this, "获取角色应用网格配置");
            gridsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows gridrows = dbConnect.runSqlQuery(gridsql);
            RowsMap gridRowsMap = gridrows.toRowsMap("systemappid");

            /**
             * 获取应用表格配置
             */
            SQLFactory tablesql = new SQLFactory(this, "获取角色应用表格配置");
            tablesql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            Rows tablerows = dbConnect.runSqlQuery(tablesql);
            RowsMap tableRowsMap = tablerows.toRowsMap("systemappid");

            SQLFactory tablecolsql = new SQLFactory(this, "获取角色应用表格栏位配置");
            tablecolsql.addParameter_in("tableid", tablerows.toArrayList("tableid"));
            Rows alltablecolRows = dbConnect.runSqlQuery(tablecolsql);
            RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select tablecolid,title,width,hidden from sys_systemapp_tablecols_site where siteid='" + siteid + "'").toRowsMap("tablecolid");
            ArrayList<Row> hiddenRow = new ArrayList<>();
            for (Row tablecolRow : alltablecolRows) {
                if (sitetablecolRowsMap.containsKey(tablecolRow.getString("tablecolid"))) {
                    Rows sitecolsRows = sitetablecolRowsMap.get(tablecolRow.getString("tablecolid"));
                    if (!sitecolsRows.get(0).getString("title").equals("")) {
                        tablecolRow.put("title", sitecolsRows.get(0).getString("title"));
                    }
                    if (sitecolsRows.get(0).getInteger("width") > 0) {
                        tablecolRow.put("width", sitecolsRows.get(0).getInteger("width"));
                    }
                    if (sitecolsRows.get(0).getInteger("hidden") == 1) {
                        tablecolRow.put("hidden", 1);
                    }
                }
                if (tablecolRow.getBoolean("hidden")) {
                    hiddenRow.add(tablecolRow);
                }
            }
            for (Row row : hiddenRow) {
                alltablecolRows.remove(row);
            }
            RowsMap tablecolRowsMap = alltablecolRows.toRowsMap("tableid");

            /**
             * 获取应用小组件配置
             */
            SQLFactory wedgitsql = new SQLFactory(this, "获取角色应用小组件配置");
            wedgitsql.addParameter_in("systemappid", appRows.toArrayList("systemappid"));
            RowsMap wedgitRowsMap = dbConnect.runSqlQuery(wedgitsql).toRowsMap("systemappid");


            for (Row systemRow : systemRows) {
                Rows modulerows = moduleRowsMap.get(systemRow.getString("systemid"));
                for (Row moduleRow : modulerows) {
                    Rows approws = appRowsMap.get(moduleRow.getString("systemmoduleid"));
                    for (Row appRow : approws) {
                        String systemappid = appRow.getString("systemappid");

                        Rows optionRows = optionRowsMap.get(systemappid);
                        optionRows.removeColumn(new String[]{"systemappid"});

                        Rows wedgitsRows = wedgitRowsMap.get(systemappid);
                        wedgitsRows.removeColumn(new String[]{"systemappid"});

                        JSONObject gridObject = new JSONObject();
                        Rows gridRows = gridRowsMap.get(systemappid);
                        for (Row gridRow : gridRows) {
                            gridObject.put(gridRow.getString("grid"), gridRow);
                        }
                        gridRows.removeColumn(new String[]{"systemappid", "grid", "gridid"});

                        JSONObject tableObject = new JSONObject();
                        Rows tableRows = tableRowsMap.get(systemappid);
                        for (Row tableRow : tableRows) {
                            Rows tablecolRows = tablecolRowsMap.get(tableRow.getString("tableid"));
                            tablecolRows.removeColumn(new String[]{"tablecolid"});
                            tableRow.put("tablecols", tablecolRows);
                            tableObject.put(tableRow.getString("table"), tableRow);
                        }
                        tableRows.removeColumn(new String[]{"systemappid", "table"});

                        JSONObject metaObject = new JSONObject();
                        metaObject.put("title", appRow.getString("systemappname"));
                        metaObject.put("auth", optionRows);
                        metaObject.put("hiddenfields", new JSONArray());
                        metaObject.put("wedgits", wedgitsRows);
                        metaObject.put("grids", gridObject);
                        metaObject.put("tables", tableObject);

                        appRow.put("path", appRow.getString("apppath"));
                        appRow.put("name", appRow.getString("systemapp"));
                        appRow.put("meta", metaObject);
                        appRow.put("component", "");
                    }
                    moduleRow.put("apps", approws);
                }
                systemRow.put("modules", modulerows);
            }
            appRows.removeColumn(new String[]{"systemappname", "systemapp", "apppath"});
            parameter.userauth_systemids.put(userid, systemRows);
            parameter.userauth_systemmoduleids.put(userid, moduleRows);
            parameter.userauth_systemappids.put(userid, appRows);
            parameter.userauth_optionids.put(userid, OptionRows);
            return getSucReturnObject().setData(systemRows).toString();
        }
    }

    @API(title = "获取当前登陆角色快捷方式信息")
    @CACHEING
    public String query_usershortcuts() throws YosException {
        String shortcuttype = "systemmodule";
        if (content.containsKey("shortcuttype")) {
            shortcuttype = content.getString("shortcuttype");
        }
        if (shortcuttype.equalsIgnoreCase("systemmodule")) {
            /*
             *查询账号有无营销物料的快捷方式，如果没有，则自动加入
             */
            if (systemclient.equalsIgnoreCase("web")) {
                if (dbConnect.runSqlQuery("select * from sys_shortcuts where siteid='" + siteid + "' and userid='" + userid + "' and systemclient='" + systemclient + "'").isEmpty()) {
                    SQLFactory sqlFactory = new SQLFactory(this, "模块快捷方式插入");
                    sqlFactory.addParameter("systemclient", systemclient);
                    sqlFactory.addParameter("siteid", siteid);
                    sqlFactory.addParameter("userid", userid);
                    sqlFactory.addParameter("systemmoduleid", 210);//媒体库
                    sqlFactory.addParameter("sequence", 1);
                    sqlFactory.addParameter("location", "mainnav");
                    sqlFactory.addParameter("issystem", 1);
                    sqlFactory.addParameter("sys_shortcutsid", createTableID("sys_shortcuts"));
                    dbConnect.runSqlUpdate(sqlFactory.getSQL());
                }
            }
            SQLFactory modulesql = new SQLFactory(this, "获取角色模块快捷方式");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);

            for (Row row : moduleRows) {
                row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
                row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
            }
            return getSucReturnObject().setData(moduleRows).toString();
        } else if (shortcuttype.equalsIgnoreCase("systemapp")) {
            SQLFactory modulesql = new SQLFactory(this, "获取角色应用快捷方式");
            modulesql.addParameter("userid", userid);
            modulesql.addParameter("siteid", siteid);
            modulesql.addParameter("systemclient", systemclient);
            Rows moduleRows = dbConnect.runSqlQuery(modulesql);
            return getSucReturnObject().setData(moduleRows).toString();
        }
        return getSucReturnObject().setData(new Rows()).toString();
    }

    @API(title = "创建登陆角色快捷方式", intervaltime = 1000)
    @CACHEING_CLEAN(cms = {@cm(clazz = userauth.class, method = {"query_usershortcuts"})})
    public String create_usershortcuts() throws YosException {
        long systemmoduleid = content.getLongValue("systemmoduleid");
        long systemappid = content.getLongValue("systemappid");
        String location = (String) content.getOrDefault("location", "mainnav");
        if (systemmoduleid > 0 && systemappid == 0) {
            SQLFactory sqlFactory = new SQLFactory(this, "模块快捷方式插入");
            sqlFactory.addParameter("systemclient", systemclient);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("userid", userid);
            sqlFactory.addParameter("systemmoduleid", systemmoduleid);
            sqlFactory.addParameter("sequence", 1);
            sqlFactory.addParameter("location", location);
            sqlFactory.addParameter("issystem", 0);
            sqlFactory.addParameter("sys_shortcutsid", createTableID("sys_shortcuts"));
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else if (systemmoduleid == 0 && systemappid > 0) {
            SQLFactory sqlFactory = new SQLFactory(this, "应用快捷方式插入");
            sqlFactory.addParameter("systemclient", systemclient);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("userid", userid);
            sqlFactory.addParameter("systemappid", systemappid);
            sqlFactory.addParameter("sequence", 1);
            sqlFactory.addParameter("location", location);
            sqlFactory.addParameter("issystem", 0);
            sqlFactory.addParameter("sys_shortcutsid", createTableID("sys_shortcuts"));
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        }
        return getSucReturnObject().toString();
    }

    @API(title = "删除登陆角色快捷方式", intervaltime = 1000)
    @CACHEING_CLEAN(cms = {@cm(clazz = userauth.class, method = {"query_usershortcuts"})})
    public String delete_usershortcuts() throws YosException {
        long systemmoduleid = content.getLongValue("systemmoduleid");
        long systemappid = content.getLongValue("systemappid");
        String location = (String) content.getOrDefault("location", "mainnav");
        if (systemmoduleid > 0 && systemappid == 0) {
            dbConnect.runSqlUpdate("delete from sys_shortcuts where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid='" + userid + "' and location='" + location + "' and systemmoduleid='" + systemmoduleid + "'");
        } else if (systemmoduleid == 0 && systemappid > 0) {
            dbConnect.runSqlUpdate("delete from sys_shortcuts where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid='" + userid + "' and location='" + location + "' and systemappid='" + systemappid + "'");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "添加禅道任务或bug")
    public String addZenTao() throws YosException {
        String type = content.getString("type");//task/bug
        long id = content.getLong("id");
        long systemappid = content.getLong("systemappid");

        SQLFactory sqlFactory = new SQLFactory(this, "禅道任务绑定");
        sqlFactory.addParameter("zentaoid", createTableID("zentao"));
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("id", id);
        sqlFactory.addParameter("type", type);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }
}
