package restcontroller.sysmanage.develop.parameter;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;

@API(title = "系统参数设置")
public class parameter extends Controller {
    public parameter(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统参数查询")
    public String queryParameterList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_parameter order by sequence");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统参数新增")
    public String insertParameter() throws YosException {
        String paramname = content.getString("paramname");
        String paramvalue = content.getString("paramvalue", true);
        String remarks = content.getString("remarks");
        if (paramname.equals("")) {
            return getErrReturnObject().setErrMsg("参数名称不可为空").toString();
        }
        if (dbConnect.runSqlQuery("select sys_parameterid from sys_parameter where paramname='" + paramname + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("参数名称不可重复").toString();
        }
        SQLFactory sqlFactory = new SQLFactory(this, "系统参数新增");
        sqlFactory.addParameter("sys_parameterid", createTableID("sys_parameter"));
        sqlFactory.addParameter("paramname", paramname);
        sqlFactory.addParameter("paramvalue", paramvalue);
        sqlFactory.addParameter("remarks", remarks);
        sqlFactory.addParameter("changeuserid", userid);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        Parameter.cleanSysParameter(paramname);
        return getSucReturnObject().toString();
    }

    @API(title = "系统参数修改")
    public String updateParameter() throws YosException {
        String paramname = content.getString("paramname");
        String paramvalue = content.getString("paramvalue", true);
        String remarks = content.getString("remarks");
        if (paramname.equals("")) {
            return getErrReturnObject().setErrMsg("参数名称不可为空").toString();
        }
        if (dbConnect.runSqlQuery("select sys_parameterid from sys_parameter where paramname='" + paramname + "'").isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到指定的系统参数").toString();
        } else {
            dbConnect.runSqlUpdate("update sys_parameter set paramvalue='" + paramvalue + "',remarks='" + remarks + "' where paramname='" + paramname + "'");
        }
        Parameter.cleanSysParameter(paramname);
        return getSucReturnObject().toString();
    }

    @API(title = "系统参数删除")
    public String deleteParameter() throws YosException {
        String paramname = content.getString("paramname");
        dbConnect.runSqlUpdate("delete from sys_parameter where paramname='" + paramname + "'");
        Parameter.cleanSysParameter(paramname);
        return getSucReturnObject().toString();
    }

    @API(title = "系统参数同步", notes = "不包含参数值")
    public String asyncParameter() throws YosException {
        String paramname = content.getString("paramname");
        String remarks = content.getString("remarks");
        Rows rows = dbConnect.runSqlQuery("select * from sys_parameter where paramname='" + paramname + "'");
        if (rows.isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "系统参数新增");
            sqlFactory.addParameter("sys_parameterid", createTableID("sys_parameter"));
            sqlFactory.addParameter("paramname", paramname);
            sqlFactory.addParameter("paramvalue", "");
            sqlFactory.addParameter("remarks", remarks);
            sqlFactory.addParameter("changeuserid", userid);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            dbConnect.runSqlUpdate("update sys_parameter set remarks='" + remarks + "' where paramname='" + paramname + "'");
        }
        return getSucReturnObject().toString();
    }

}
