package restcontroller.sysmanage.develop.coderule;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.ArrayList;

@API(title = "编码规则管理")
public class coderule extends Controller {
    public coderule(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "编码规则列表查询")
    public String query_coderuleList() throws YosException {
        Rows sys_coderuleRows = dbConnect.runSqlQuery("select sys_coderuleid,fixed,numlength,numincludetime,timeformat,coderuletype,notes from sys_coderule");
        ArrayList<String> site_coderuleList = dbConnect.runSqlQuery("select sys_coderuleid from sys_coderules ").toArrayList("sys_coderuleid");
        for (Row row : sys_coderuleRows) {
            row.put("hasChildren", site_coderuleList.contains(row.getString("sys_coderuleid")));
            row.put("siteid", "");
        }
        return getSucReturnObject().setData(sys_coderuleRows).toString();
    }

    @API(title = "站点编码规则列表查询")
    public String query_coderulesList() throws YosException {
        long sys_coderuleid = content.getLong("sys_coderuleid");
        Rows sys_coderuleRows = dbConnect.runSqlQuery("select sys_coderulesid,siteid,fixed,numlength,serialnum,numincludetime,timeformat from sys_coderules where sys_coderuleid=" + sys_coderuleid);
        for (Row row : sys_coderuleRows) {
            row.put("hasChildren", false);
        }
        return getSucReturnObject().setData(sys_coderuleRows).toString();
    }

    @API(title = "编码规则新增修改")
    public String insertormodify_coderule() throws YosException {
        long sys_coderuleid = content.getLongValue("sys_coderuleid");//新增时传0
        String coderuletype = content.getString("coderuletype");
        String fixed = content.getString("fixed");
        int numlength = content.getInteger("numlength");
        int numincludetime = content.getIntValue("numincludetime");
        String timeformat = content.getString("timeformat");
        String notes = content.getString("notes");
        if (content.getBooleanValue("isasync")) {
            Rows sys_coderuleRows = dbConnect.runSqlQuery("select *from sys_coderule where coderuletype='" + coderuletype + "'");
            if (sys_coderuleRows.isEmpty()) {
                SQLFactory sitecoderuleinsertSQl = new SQLFactory(this, "编码规则插入");
                sitecoderuleinsertSQl.addParameter("sys_coderuleid", createTableID("sys_coderule"));
                sitecoderuleinsertSQl.addParameter("coderuletype", coderuletype);
                sitecoderuleinsertSQl.addParameter("fixed", fixed);
                sitecoderuleinsertSQl.addParameter("numlength", numlength);
                sitecoderuleinsertSQl.addParameter("numincludetime", numincludetime);
                sitecoderuleinsertSQl.addParameter("timeformat", timeformat);
                sitecoderuleinsertSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(sitecoderuleinsertSQl.getSQL());
            } else {
                sys_coderuleid = sys_coderuleRows.get(0).getLong("sys_coderuleid");
                SQLFactory sitecoderuleupdateSQl = new SQLFactory(this, "编码规则修改");
                sitecoderuleupdateSQl.addParameter("sys_coderuleid", sys_coderuleid);
                sitecoderuleupdateSQl.addParameter("fixed", fixed);
                sitecoderuleupdateSQl.addParameter("numlength", numlength);
                sitecoderuleupdateSQl.addParameter("numincludetime", numincludetime);
                sitecoderuleupdateSQl.addParameter("timeformat", timeformat);
                sitecoderuleupdateSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(sitecoderuleupdateSQl.getSQL());
            }
            return getSucReturnObject().toString();
        } else {
            if (sys_coderuleid <= 0 || dbConnect.runSqlQuery("select *from sys_coderule where sys_coderuleid=" + sys_coderuleid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_coderule where coderuletype='" + coderuletype + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("编码规则名称不可重复！").toString();
                }
                SQLFactory sitecoderuleinsertSQl = new SQLFactory(this, "编码规则插入");
                sitecoderuleinsertSQl.addParameter("sys_coderuleid", createTableID("sys_coderule"));
                sitecoderuleinsertSQl.addParameter("coderuletype", coderuletype);
                sitecoderuleinsertSQl.addParameter("fixed", fixed);
                sitecoderuleinsertSQl.addParameter("numlength", numlength);
                sitecoderuleinsertSQl.addParameter("numincludetime", numincludetime);
                sitecoderuleinsertSQl.addParameter("timeformat", timeformat);
                sitecoderuleinsertSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(sitecoderuleinsertSQl.getSQL());
            } else {
                SQLFactory sitecoderuleupdateSQl = new SQLFactory(this, "编码规则修改");
                sitecoderuleupdateSQl.addParameter("sys_coderuleid", sys_coderuleid);
                sitecoderuleupdateSQl.addParameter("fixed", fixed);
                sitecoderuleupdateSQl.addParameter("numlength", numlength);
                sitecoderuleupdateSQl.addParameter("numincludetime", numincludetime);
                sitecoderuleupdateSQl.addParameter("timeformat", timeformat);
                sitecoderuleupdateSQl.addParameter("notes", notes);
                dbConnect.runSqlUpdate(sitecoderuleupdateSQl.getSQL());
            }
            return getSucReturnObject().toString();
        }
    }

    @API(title = "编码规则删除")
    public String delete_coderule() throws YosException {
        long sys_coderuleid = content.getLong("sys_coderuleid");
        if (dbConnect.runSqlQuery("select * from sys_coderules where sys_coderuleid=" + sys_coderuleid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("编码规则已被使用，不可删除！").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_coderule where sys_coderuleid=" + sys_coderuleid);
        return getSucReturnObject().toString();
    }
}
