package common.data.db.initialization;

import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import common.parameter.properties;
import org.reflections.Reflections;

import java.lang.reflect.Constructor;
import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class DBInitialization {

    public static void main(String[] args) throws YosException {
        DBInitialization.SchemaInit();
    }

    public static void SchemaInit() throws YosException {
        Properties p = properties.getYosProperties();
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            Class.forName(p.getProperty("system.db.driver"));
            String url = p.getProperty("system.db.url");
            String dbname = url.substring(url.lastIndexOf("/") + 1);
            url = url.replace(url.substring(url.lastIndexOf("/")), "/INFORMATION_SCHEMA");
            conn = DriverManager.getConnection(url, p.getProperty("system.db.username"),
                    p.getProperty("system.db.password"));
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
            statement = conn.prepareStatement("select count(0)as count from INFORMATION_SCHEMA.SCHEMATA where SCHEMA_NAME='" + dbname + "'");
            ResultSet resultSet = statement.executeQuery();
            boolean havedb = false;
            if (resultSet.next()) {
                havedb = resultSet.getLong("count") > 0;
            }
            resultSet.close();
            if (!havedb) {
                statement = conn.prepareStatement("CREATE DATABASE IF NOT EXISTS " + dbname + " DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_0900_ai_ci;");
                statement.executeUpdate();
                conn.commit();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            } catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        ObjectInit();
    }

    private static HashMap<String, String> sys_tableMap = new HashMap<>();
    private static RowsMap sys_table_colsMap = new RowsMap();

    private static void ObjectInit() throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows tablerows = dbConnect.runSqlQuery("select table_name,table_comment from sys_object ");
        for (Row row : tablerows) {
            sys_tableMap.put(row.getString("table_name").toLowerCase(), row.getString("table_comment").toLowerCase());
        }
        sys_table_colsMap = dbConnect.runSqlQuery("select * from sys_objectcols").toRowsMap("table_name");

        Reflections reflections = new Reflections();
        Set<Class<? extends YosObject>> subTypes = reflections.getSubTypesOf(YosObject.class);

        ArrayList<String> sqlist = new ArrayList<>();
        for (Class yosObject : subTypes) {
            try {
                Constructor cla = yosObject.getDeclaredConstructor();
                getObjectChangeSQL((YosObject) cla.newInstance(), sqlist);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (sqlist.size() > 0) {
            dbConnect.runSqlUpdate(sqlist);
        }
    }

    private static void getObjectChangeSQL(YosObject yosObject, ArrayList<String> sqlist) throws YosException {
        String table_name = yosObject.getClass().getSimpleName().toLowerCase();
        String table_comment = yosObject.table_comment();
        if (sys_tableMap.containsKey(table_name)) {
            if (!sys_tableMap.get(table_name).equals(table_comment)) {
                SQLFactory modifyTable = new SQLFactory(new DBInitialization(), "表修改");
                modifyTable.addParameter("table_name", table_name);
                modifyTable.addParameter("table_comment", table_comment);
                sqlist.add(modifyTable.getSQL());
            }
            RowsMap columnRowsMap = sys_table_colsMap.get(table_name).toRowsMap("column_name");

            ArrayList<YosObjectCol> changeColList = new ArrayList<>();
            for (YosObjectCol yosObjectCol : yosObject.table_cols()) {
                if (columnRowsMap.containsKey(yosObjectCol.getColumn_name())) {
                    Row column = columnRowsMap.get(yosObjectCol.getColumn_name()).get(0);
                    if (!yosObjectCol.getColumn_comment().equals(column.getString("column_comment"))
                            || yosObjectCol.getIs_nullable() != column.getBoolean("is_nullable")
                            || !yosObjectCol.getColumn_default().equals(column.getString("column_default"))
                            || !yosObjectCol.getColumn_title().equals(column.getString("column_title"))) {

                        SQLFactory modifyCol = new SQLFactory(new DBInitialization(), "字段修改");
                        modifyCol.addParameter("table_name", table_name);
                        modifyCol.addParameter("column_name", yosObjectCol.getColumn_name());
                        modifyCol.addParameter("column_title", yosObjectCol.getColumn_title());
                        modifyCol.addParameter("column_default", yosObjectCol.getColumn_default());
                        modifyCol.addParameter("numeric_precision", yosObjectCol.getNumeric_precision());
                        modifyCol.addParameter("numeric_scale", yosObjectCol.getNumeric_scale());
                        modifyCol.addParameter("column_comment", yosObjectCol.getColumn_comment());
                        modifyCol.addParameter("is_nullable", yosObjectCol.getIs_nullable() ? 1 : 0);
                        modifyCol.addParameter("savedatalog", yosObjectCol.getSavedatalog() ? 1 : 0);
                        modifyCol.addParameter("uniqued", yosObjectCol.getUniqued() ? 1 : 0);
                        sqlist.add(modifyCol.getSQL());

                        yosObjectCol.setColstatus(YosObject.ChangeStatus.C);
                        changeColList.add(yosObjectCol);
                    }
                } else {
                    SQLFactory insertCol = new SQLFactory(new DBInitialization(), "字段新增");
                    insertCol.addParameter("table_name", table_name);
                    insertCol.addParameter("column_name", yosObjectCol.getColumn_name());
                    insertCol.addParameter("column_title", yosObjectCol.getColumn_title());
                    insertCol.addParameter("column_default", yosObjectCol.getColumn_default());
                    insertCol.addParameter("numeric_precision", yosObjectCol.getNumeric_precision());
                    insertCol.addParameter("numeric_scale", yosObjectCol.getNumeric_scale());
                    insertCol.addParameter("column_type", yosObjectCol.getColumn_type());
                    insertCol.addParameter("column_comment", yosObjectCol.getColumn_comment());
                    insertCol.addParameter("is_nullable", yosObjectCol.getIs_nullable() ? 1 : 0);
                    insertCol.addParameter("savedatalog", yosObjectCol.getSavedatalog() ? 1 : 0);
                    insertCol.addParameter("uniqued", yosObjectCol.getUniqued() ? 1 : 0);
                    insertCol.addParameter("sequence", yosObjectCol.getSequence());
                    sqlist.add(insertCol.getSQL());

                    yosObjectCol.setColstatus(YosObject.ChangeStatus.A);
                    changeColList.add(yosObjectCol);
                }
            }
            if (!sys_tableMap.get(table_name).equals(table_comment) || !changeColList.isEmpty()) {
                applydbchanges(yosObject, YosObject.ChangeStatus.C, changeColList, sqlist);
            }
        } else if (!sys_tableMap.containsKey(table_name)) {
            SQLFactory insertTable = new SQLFactory(new DBInitialization(), "表新增");
            insertTable.addParameter("table_name", table_name);
            insertTable.addParameter("table_comment", table_comment);
            insertTable.addParameter("uniquecolumnname", yosObject.uniquecolumn().getColumn_name());
            sqlist.add(insertTable.getSQL());

            for (YosObjectCol yosObjectCol : yosObject.table_cols()) {
                SQLFactory insertCol = new SQLFactory(new DBInitialization(), "字段新增");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", yosObjectCol.getColumn_name());
                insertCol.addParameter("column_title", yosObjectCol.getColumn_title());
                insertCol.addParameter("column_default", yosObjectCol.getColumn_default());
                insertCol.addParameter("numeric_precision", yosObjectCol.getNumeric_precision());
                insertCol.addParameter("numeric_scale", yosObjectCol.getNumeric_scale());
                insertCol.addParameter("column_type", yosObjectCol.getColumn_type());
                insertCol.addParameter("column_comment", yosObjectCol.getColumn_comment());
                insertCol.addParameter("is_nullable", yosObjectCol.getIs_nullable() ? 1 : 0);
                insertCol.addParameter("savedatalog", yosObjectCol.getSavedatalog() ? 1 : 0);
                insertCol.addParameter("uniqued", yosObjectCol.getUniqued() ? 1 : 0);
                insertCol.addParameter("sequence", yosObjectCol.getSequence());
                sqlist.add(insertCol.getSQL());
            }
            applydbchanges(yosObject, YosObject.ChangeStatus.A, yosObject.table_cols(), sqlist);
        }
    }

    private static void applydbchanges(YosObject yosObject, YosObject.ChangeStatus tablestatus, ArrayList<YosObjectCol> yosObjectCollist, ArrayList<String> sqllist) throws YosException {
        DBConnect dbConnect = new DBConnect();
        String table_name = yosObject.getClass().getSimpleName();
        String table_comment = yosObject.table_comment();
        switch (tablestatus) {
            case C: {
                sqllist.add("alter table " + yosObject.getClass().getSimpleName() + " comment '" + table_comment + "';");
                for (YosObjectCol yosObjectCol : yosObjectCollist) {
                    YosObject.ChangeStatus colstatus = yosObjectCol.getColstatus();//更改状态
                    String column_name = yosObjectCol.getColumn_name();//字段名称
                    String column_type = yosObjectCol.getColumn_type().toString();//字段类型
                    int numeric_precision = yosObjectCol.getNumeric_precision();//长度
                    int numeric_scale = yosObjectCol.getNumeric_scale();//小数位数
                    String column_default = yosObjectCol.getColumn_default();//默认值
                    boolean is_nullable = yosObjectCol.getIs_nullable();//是否允许为空
                    String column_comment = yosObjectCol.getColumn_comment();//字段备注
                    boolean uniqued = yosObjectCol.getUniqued();//是否唯一
                    String oldindexname = table_name + "_" + column_name + "_uindex";
                    String indexname = column_name + "_uindex";
                    boolean isallreadyhaveoldindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + oldindexname + "'").isNotEmpty();
                    boolean isallreadyhaveindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + indexname + "'").isNotEmpty();

                    String type = getColumn_type(column_type, numeric_precision, numeric_scale);

                    //判断字段是否已存在
                    boolean isallreadycolhave = !dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'").isEmpty();

                    switch (colstatus) {
                        case C:
                        case A: {
                            if (isallreadycolhave) {
                                sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + (column_default.equals("") ? " " : (" default '" + column_default + "' ")) + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                            } else {
                                sqllist.add("alter table " + table_name + " add " + column_name + " " + type + (column_default.equals("") ? " " : (" default '" + column_default + "' ")) + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                            }
                            /*
                            检查是否有该字段的唯一索引
                             */
                            if (uniqued && !isallreadyhaveindex) {
                                sqllist.add("create unique index " + indexname + " on " + table_name + " (" + column_name + ");");
                            } else if (!uniqued && isallreadyhaveindex) {
                                sqllist.add("drop index " + indexname + " on " + table_name + ";");
                            } else if (!uniqued && isallreadyhaveoldindex) {
                                sqllist.add("drop index " + oldindexname + " on " + table_name + ";");
                            }
                            break;
                        }
                        default:
                            break;
                    }
                }
                break;
            }
            case A: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("create table ").append(table_name);
                stringBuffer.append("(");
                for (YosObjectCol yosObjectCol : yosObjectCollist) {
                    String column_name = yosObjectCol.getColumn_name();//字段名称
                    String column_type = yosObjectCol.getColumn_type().toString();//字段类型
                    int numeric_precision = yosObjectCol.getNumeric_precision();//长度
                    int numeric_scale = yosObjectCol.getNumeric_scale();//小数位数
                    String column_default = yosObjectCol.getColumn_default();//默认值
                    boolean is_nullable = yosObjectCol.getIs_nullable();//是否允许为空
                    String column_comment = yosObjectCol.getColumn_comment();//字段备注
                    String type = getColumn_type(column_type, numeric_precision, numeric_scale);

                    stringBuffer.append(column_name + " " + type + (column_default.equals("") ? " " : (" default '" + column_default + "' ")) + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "',");
                }
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
                stringBuffer.append(")");
                stringBuffer.append("comment '" + table_comment + "';");
                sqllist.add(stringBuffer.toString());

                for (YosObjectCol yosObjectCol : yosObjectCollist) {
                    String column_name = yosObjectCol.getColumn_name();//字段名称
                    boolean uniqued = yosObjectCol.getUniqued();//是否唯一
                    /*检查是否有该字段的唯一索引
                     */
                    String oldindexname = table_name + "_" + column_name + "_uindex";
                    String indexname = column_name + "_uindex";

                    boolean isallreadyhaveoldindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + oldindexname + "'").isNotEmpty();
                    boolean isallreadyhaveindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + indexname + "'").isNotEmpty();

                    if (uniqued && !isallreadyhaveindex) {
                        sqllist.add("create unique index " + indexname + " on " + table_name + " (" + column_name + ");");
                    } else if (!uniqued && isallreadyhaveindex) {
                        sqllist.add("drop index " + indexname + " on " + table_name + ";");
                    } else if (!uniqued && isallreadyhaveoldindex) {
                        sqllist.add("drop index " + oldindexname + " on " + table_name + ";");
                    }
                }
                break;
            }
            default:
                break;
        }

        sqllist.add("update sys_object set status=null,changedate=now() where table_name='" + table_name + "'");
        sqllist.add("update sys_objectcols set status=null where table_name='" + table_name + "'");

       /*
        为表创建主键
        */
        if (dbConnect.runSqlQuery("select *from INFORMATION_SCHEMA.KEY_COLUMN_USAGE where TABLE_NAME='" + table_name + "' and CONSTRAINT_NAME='PRIMARY'").isEmpty()) {
            String uniquecolumnname = yosObject.uniquecolumn().getColumn_name();
            if (!uniquecolumnname.equalsIgnoreCase("")) {
                sqllist.add("alter table " + table_name + " add constraint " + table_name + "_pk primary key (" + uniquecolumnname + ");");
            }
        }
    }

    private static String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        } else if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        } else {
            return column_type;
        }
    }
}
