package common.data.db;

import com.alibaba.fastjson.JSONArray;
import common.data.Row;
import common.data.Rows;

import java.math.BigDecimal;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class SQLiteMemory {
    private static Connection conn = null;

    private static void createConnect() {
        if (conn == null) {
            try {
                Class.forName("org.sqlite.JDBC");
                conn = DriverManager.getConnection("jdbc:sqlite::memory:");
                conn.setAutoCommit(false);
            } catch (Exception e) {
                System.err.println("sqlite缓存数据库连接失败");
            }
        }
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static void runSqlUpdate(String SQL) {
        createConnect();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(SQL);
            statement.executeUpdate();
            conn.commit();
        } catch (Exception e) {
            System.err.println("sqlite缓存数据库更新失败:" + SQL + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static void runSqlUpdate(ArrayList<String> SQLlist) {
        createConnect();
        PreparedStatement statement = null;
        try {
            for (String sql : SQLlist) {
                statement = conn.prepareStatement(sql);
                statement.executeUpdate();
            }
            conn.commit();
        } catch (Exception e) {
            System.err.println("sqlite缓存数据库更新失败:" + JSONArray.toJSON(SQLlist) + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static Rows runSqlQuery(String SQL) {
        createConnect();
        Rows rows = new Rows();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();

            ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            List<String> colNameList = new ArrayList<String>();
            List<String> colTypeList = new ArrayList<String>();
            for (int i = 0; i < colCount; i++) {
                colNameList.add(rsmd.getColumnName(i + 1));
                colTypeList.add(rsmd.getColumnTypeName(i + 1));
            }
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; i++) {
                    String key = colNameList.get(i);
                    String type = colTypeList.get(i).toLowerCase();
                    Object value;
                    switch (type) {
                        case "int":
                            value = resultSet.getInt(colNameList.get(i));
                            break;
                        case "bigint":
                            value = resultSet.getLong(colNameList.get(i));
                            break;
                        case "smallint":
                            value = resultSet.getShort(colNameList.get(i));
                            break;
                        case "float":
                        case "numeric":
                        case "decimal":
                            value = resultSet.getBigDecimal(colNameList.get(i));
                            break;
                        case "datetime":
                            value = resultSet.getString(colNameList.get(i));
                            if (value != null) {
                                value = ((String) value).replace(" 00:00:00.0", "");
                            }
                            break;
                        case "date":
                        default:
                            value = resultSet.getString(colNameList.get(i));
                            break;
                    }
                    if ("total".equals(key)) {
                        rows.totalRows = (Long) value;

                    } else if ("pageTotal".equals(key)) {
                        rows.totalPage = ((BigDecimal) value).longValue();
                    } else {
                        row.put(key, value);
                    }
                }
                rows.add(row);
            }
        } catch (Exception e) {
            System.err.println("sqlite缓存数据库执行查询失败:" + SQL + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                resultSet.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }
}
