package common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.data.Row;
import common.data.Rows;

public class ReturnObject_Suc extends ReturnObject {

    boolean ispaging = false;

    public ReturnObject_Suc(Controller controller) {
        super(controller);
        this.put("msg", "成功");
        this.put("code", 1);
        this.put("data", "成功");
    }

    public ReturnObject_Suc setData(Rows rows) {
        ispaging = true;
        JSONArray dataArray = rows.toJsonArray();
        this.put("data", dataArray);
        this.put("pageNumber", controller.pageNumber);
        this.put("pageSize", Math.max(dataArray.size(), controller.pageSize));
        this.put("total", Math.max(rows.getTotalRows(), dataArray.size()));
        this.put("pageTotal", rows.getTotalPage());
        this.put("sort", controller.pageSortingArray);
        return this;
    }

    @Deprecated
    public ReturnObject_Suc setDataByPaging(Rows rows) {
        ispaging = true;
        this.put("data", rows.toJsonArray());
        this.put("pageNumber", controller.pageNumber);
        this.put("pageSize", controller.pageSize);
        this.put("total", rows.getTotalRows());
        this.put("pageTotal", rows.getTotalPage());
        this.put("sort", controller.pageSortingArray);
        return this;
    }

    public ReturnObject_Suc setData(Row row) {
        this.put("data", row.toJsonObject());
        return this;
    }

    public ReturnObject_Suc setData(Object data) {
        this.put("data", data);
        return this;
    }

    public ReturnObject_Suc setData(String data) {
        this.put("data", data);
        return this;
    }

    public ReturnObject_Suc setTips(JSONObject tips) {
        this.put("tips", tips);
        return this;
    }

    public ReturnObject_Suc addAppHelpNotes(long tarchives_scid) {
        this.put("tarchives_scid", tarchives_scid);
        return this;
    }

    public ReturnObject_Suc addKeyValue(String key, Object value) {
        this.put(key, value);
        return this;
    }
}
